/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.CompStatExplain;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.HasStatusDependents;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusExplain;
import ibm.nways.jdm.StatusImageFilter;
import ibm.nways.jdm.Watchable;
import ibm.nways.jdm.Watcher;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.util.ResourceBundle;

public class GraphicImage
extends GraphicComponent
implements Watcher {
    static Object lock = new Object();
    private Image image;
    private Image filteredImage;
    private Color currentStatusColor;
    private Color previousStatusColor;
    private Status status;
    protected static ResourceBundle myResources = null;
    public static final String StatusMenuName = "GraphicImageStatusMenu";

    public GraphicImage() {
    }

    public GraphicImage(Image image, Point point, int n) {
        this(image, point, n, null, null);
    }

    public GraphicImage(Image image, Point point, int n, GraphicAction graphicAction, Status status) {
        this.setImage(image);
        this.setLocation(point);
        this.setZOrder(n);
        this.setAction(graphicAction);
        this.setStatus(status);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.setSize(image.getWidth(this), image.getHeight(this));
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        try {
            if (this.status == status) {
                return;
            }
            if (this.status != null) {
                this.status.deleteWatcher(this);
            }
            this.status = status;
            if (status != null) {
                status.addWatcher(this);
                this.checkStatus();
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void checkStatus() {
        if (this.status != null) {
            Color color = this.status.getStatusType().getColor();
            if (this.filteredImage == null || color != this.currentStatusColor) {
                MediaTracker mediaTracker = new MediaTracker(this);
                FilteredImageSource filteredImageSource = new FilteredImageSource(this.image.getSource(), new StatusImageFilter(color));
                Object object = lock;
                synchronized (object) {
                    this.filteredImage = this.createImage(filteredImageSource);
                    mediaTracker.addImage(this.filteredImage, 0);
                    try {
                        mediaTracker.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (mediaTracker.isErrorID(0)) {
                        this.filteredImage = null;
                    } else {
                        this.currentStatusColor = color;
                    }
                }
            }
            if (this.currentStatusColor != this.previousStatusColor && this.isShowing()) {
                this.repaint();
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.image != null) {
            dimension.width = this.image.getWidth(this);
            dimension.height = this.image.getHeight(this);
        }
        return dimension;
    }

    public void paint(Graphics graphics) {
        if (this.status == null || this.filteredImage == null) {
            this.filteredImage = this.image;
        }
        this.previousStatusColor = this.currentStatusColor;
        graphics.drawImage(this.filteredImage, 0, 0, this);
        super.paint(graphics);
    }

    public void update(Watchable watchable, Object object) {
        this.checkStatus();
    }

    public PopupMenu getNewPopupMenu() {
        PopupMenu popupMenu = super.getNewPopupMenu();
        Menu menu = new Menu(GraphicImage.messageText("Status"));
        menu.setName(StatusMenuName);
        popupMenu.add(menu);
        MenuItem menuItem = new MenuItem(GraphicImage.messageText("ExplainStatus"));
        menuItem.addActionListener(new ExplainStatusAdapter());
        menu.add(menuItem);
        menuItem = new MenuItem(GraphicImage.messageText("CheckStatus"));
        menuItem.addActionListener(new CheckStatusAdapter());
        menu.add(menuItem);
        return popupMenu;
    }

    protected void previewPopup(PopupMenu popupMenu) {
        MenuItem menuItem = this.getMenuItemNamed(popupMenu, StatusMenuName);
        if (menuItem == null) {
            return;
        }
        if (this.status == null) {
            menuItem.setEnabled(false);
        }
    }

    private MenuItem getMenuItemNamed(Menu menu, String string) {
        MenuItem menuItem = null;
        int n = menu.getItemCount() - 1;
        while (n >= 0) {
            MenuItem menuItem2 = menu.getItem(n);
            if (menuItem2.getName().equals(string)) {
                menuItem = menuItem2;
                break;
            }
            --n;
        }
        return menuItem;
    }

    private void explainStatusAction() {
        if (this.status instanceof HasStatusDependents) {
            CompStatExplain compStatExplain = new CompStatExplain(this.findBrowserApplet(), this.status);
            compStatExplain.show();
            return;
        }
        StatusExplain statusExplain = new StatusExplain(this.findBrowserApplet(), this.status);
        statusExplain.show();
    }

    private void checkStatusAction() {
        this.status.check();
    }

    private BrowserApplet findBrowserApplet() {
        BrowserApplet browserApplet = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof BrowserApplet) {
                browserApplet = (BrowserApplet)container;
                break;
            }
            container = container.getParent();
        }
        return browserApplet;
    }

    protected static String messageText(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.GraphicImageResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public void dispose() {
        this.setStatus(null);
        super.dispose();
    }

    final /* synthetic */ void access$0() {
        this.checkStatusAction();
    }

    final /* synthetic */ void access$1() {
        this.explainStatusAction();
    }

    class ExplainStatusAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicImage.this.access$1();
        }

        ExplainStatusAdapter() {
            GraphicImage.this = GraphicImage.this;
        }
    }

    class CheckStatusAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicImage.this.access$0();
        }

        CheckStatusAdapter() {
            GraphicImage.this = GraphicImage.this;
        }
    }
}

